definition module deltaBitmap


//	Clean 0.8 I/O library.
//	Interface functions for drawing bitmaps.


from deltaPicture	import Point, Rectangle, Picture, Vector
from StdFile		import FileSystem


::	Bitmap

openBitmap		:: !{#Char} !*env -> (!(!Bool,!Bitmap), !*env)	| FileSystem env
/*	openBitmap attempts to read in a bitmap from file.
	The String argument must be the file name of the bitmap.
	The Bool   result is True iff the bitmap could be successfully read.
	The Bitmap result is only a Bitmap if the bitmap could be read.
*/

getBitmapSize	:: !Bitmap -> (!Int,!Int)
/*	getBitmapSize returns the width and height of the given bitmap.
	In case the bitmap is the result of an erroneous loadBitmap, then
	the size is zero.
*/

resizeBitmap :: !Bitmap !Vector -> Bitmap
/*	zooms or stretches a bitmap. The second argument is the width and height
	of the resulting bitmap
*/

drawBitmap		:: !Point !Rectangle !Bitmap !Picture -> Picture
/*	drawBitmap draws a part of a bitmap.
	The Point     argument is the left top position where the bitmap part will be drawn.
	The Rectangle argument indicates the part of the bitmap that will be drawn. 
					Its values are always corrected within the size of the bitmap.
	The Bitmap    argument is the bitmap that should be drawn.
					In case it is the result of an erroneous loadBitmap operation, no
					drawing occurs.
*/

